//
//  TTTSymbol.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/4/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTSymbol.h"

@implementation TTTSymbol
    static TTTSymbol *SymbolX=nil;
    static TTTSymbol *SymbolO=nil;
    static TTTSymbol *SymbolBlank=nil;
    static BOOL bitMapsInitialized = NO;
    static UIImage *imageBlank=nil;
    static UIImage *imageX=nil;
    static UIImage *imageO=nil;

	
    +(TTTSymbol*) SymbolXCreate{
        @synchronized([TTTSymbol class]){
            if (SymbolX == nil){
                SymbolX = [[TTTSymbol alloc] init];
                SymbolX->value = MARKX;
            }
            return SymbolX;
        }
    }
	
    +(TTTSymbol*) SymbolOCreate{
        @synchronized([TTTSymbol class]){
            if (SymbolO == nil){
                SymbolO = [[TTTSymbol alloc] init];
                SymbolO->value = MARKO;
            }
            return SymbolO;
        }
    }
        
    +(TTTSymbol*) SymbolBlankCreate{
       @synchronized([TTTSymbol class]){
          if (SymbolBlank == nil){
                    SymbolBlank = [[TTTSymbol alloc] init];
                    SymbolBlank->value = MARKBLANK;
          }
          return SymbolBlank;
       }
    }

	-(NSString *) toString{
		if (value == MARKX) return @"X";
		else if (value == MARKO) return @"O";
		else return @"";
	}

    - (UIImage *) getBitmapForSymbol{
        @synchronized([TTTSymbol class]){
            if (!bitMapsInitialized){
                NSString* imagePath =
                    [[NSBundle mainBundle] pathForResource:@"Images.bundle/x" ofType:@"png"];
                imageX = [[UIImage alloc] initWithContentsOfFile:imagePath];
                imagePath = [[NSBundle mainBundle] pathForResource:@"Images.bundle/o" ofType:@"png"];
                imageO = [[UIImage alloc] initWithContentsOfFile:imagePath];
                imagePath = [[NSBundle mainBundle] pathForResource:@"Images.bundle/blank" ofType:@"png"];
                imageBlank = [[UIImage alloc] initWithContentsOfFile:imagePath];
                bitMapsInitialized=true;
            }
        }
        UIImage *imageSelected = imageBlank;
    
        if (self == [TTTSymbol SymbolXCreate]) imageSelected = imageX;
        else if (self == [TTTSymbol SymbolOCreate]) imageSelected = imageO;
        return imageSelected;
    }

@end
